/*<![CDATA[*/
//V2.0

/*
Release Notes:
2.0
_Switch to smartform API V2
_Captcha verification via Google ReCaptcha and Friendly Captcha added.
_Bugfix for "for" attribute in labels.

1.4.1
_Fieldset for checkboxes and radio buttons added.
_Autofill attribute for form tag added.
_Autocomplete attrbutes for various input field added.

1.4
_Bugfix for Single-Selections submit
_New config option "show_label_in":
    _"label" shows label as field label
    _"placeholder" shows label as placeholder in text inputs.
    _"both" (default) shows labels as field label and ploceholder für text inputs.

1.3
_Evalanche profile id can now be given via url parameter. The parameter name can be defined with the new config option "url_profileid_parameter".

1.2.2
1.2.1
_Bufix for inverted checkboxes submit.
_Various HTML tags now get a optional classname given by the new config option "class_name".
_Field labels now can be HTML.

1.0
_First stable version.

*/

class Widget {
    constructor(show_label_in) {
        this.show_label_in = show_label_in;
    }

    get dom() {
        return this.dom_widget;
    }

    set_validation_error() {
        console.log(this);
        if (Array.isArray(this.input)) {
            this.input.forEach(function (input) {
                input.classList.add("validation_error");
            });
        } else {
            this.input.classList.add("validation_error");
        }

        if (Object.hasOwn(this, "dom_error_message")) {
            this.dom_error_message.style.display = "block";
        }

        return;
    }

    create_widget_dom() {
        var field = this.field;

        const dom_field = document.createElement("div");
        dom_field.id = field.form_id_prefix + "field_" + field.name;

        if (this.show_label_in == "both" || this.show_label_in == "label") {
            const dom_field_label = this.create_label();
            dom_field.appendChild(dom_field_label);
        }

        const dom_field_input = this.create_input();
        dom_field.appendChild(dom_field_input);

        this.input = dom_field_input;

        return dom_field;
    }

    create_label() {
        var field = this.field;

        const dom_field_label = document.createElement("label");
        dom_field_label.classList.add(field.class_name);
        dom_field_label.classList.add(this.type);
        dom_field_label.id = field.form_id_prefix + "label_" + field.name;
        dom_field_label.innerHTML = field.label;
        dom_field_label.htmlFor = field.name;
        this.dom_label = dom_field_label;

        if (field.required) {
            dom_field_label.classList.add("mandatory");
        }

        return dom_field_label;
    }

    create_input() {
        var field = this.field;
        var type = this.type;

        const dom_field_input = document.createElement("input");
        dom_field_input.classList.add(field.class_name);
        dom_field_input.type = type;
        dom_field_input.name = field.name;
        dom_field_input.id = field.name;

        switch (type) {
            case "checkbox":
                if ("profile_default_value" in field) {
                    if (field.profile_default_value == "1") {
                        dom_field_input.checked = "checked";
                    }
                } else {
                    if (field.default_value == "1") {
                        dom_field_input.checked = "checked";
                    }
                }
                break;
            case "date":
                if ("profile_default_value" in field) {
                    var date = new Date(field.profile_default_value * 1000);
                } else {
                    var date = new Date(field.default_value * 1000);
                }
                dom_field_input.value = date.toISOString().substring(0, 10);
                break;
            case "datetime-local":
                if ("profile_default_value" in field) {
                    var date = new Date(field.profile_default_value * 1000);
                } else {
                    var date = new Date(field.default_value * 1000);
                }
                dom_field_input.value = date.toISOString().substring(0, 16).replace("T", " ");

                break;
            default:
                switch (field.name) {
                    case "form_FAXNUMBER":
                        dom_field_input.autocomplete = "fax";
                        break;
                    case "form_PHONENUMBER":
                        dom_field_input.autocomplete = "tel";
                        break;
                    case "form_EMAIL":
                        dom_field_input.autocomplete = "email";
                        break;
                    case "form_NAME":
                        dom_field_input.autocomplete = "family-name";
                        break;
                    case "form_FIRSTNAME":
                        dom_field_input.autocomplete = "given-name";
                        break;
                    case "form_COMPANY":
                        dom_field_input.autocomplete = "organization";
                        break;
                    case "form_ZIPCODE":
                        dom_field_input.autocomplete = "postal-code";
                        break;
                }
                if (this.show_label_in == "both" || this.show_label_in == "placeholder") {
                    dom_field_input.placeholder = field.label;
                }

                if ("profile_default_value" in field) {
                    dom_field_input.value = field.profile_default_value;
                } else {
                    dom_field_input.value = field.default_value;
                }
        }
        if (field.required) {
            dom_field_input.classList.add("mandatory");
        }

        return dom_field_input;
    }

    create_radio_option(value, label) {
        var field = this.field;

        const dom_field_option = document.createElement("div");

        const dom_field_input_option = this.create_input("radio");
        dom_field_input_option.value = value;
        dom_field_input_option.id = field.form_id_prefix + field.name + ":" + value;
        dom_field_option.appendChild(dom_field_input_option);
        this.input.push(dom_field_input_option);

        const dom_field_label = document.createElement("label");
        dom_field_label.classList.add(field.class_name);
        dom_field_label.classList.add("radio");
        dom_field_label.htmlFor = dom_field_input_option.name;
        dom_field_option.appendChild(dom_field_label);

        const dom_field_text = document.createElement("span");
        dom_field_text.classList.add(field.class_name);
        dom_field_text.innerHTML = label;
        dom_field_label.appendChild(dom_field_text);

        if ("profile_default_value" in field) {
            if (field.profile_default_value.indexOf(parseInt(value)) > -1) {
                dom_field_input_option.checked = "checked";
            }
        } else {
            if (field.default_value.indexOf(parseInt(value)) > -1) {
                dom_field_input_option.checked = "checked";
            }
        }

        return dom_field_option;
    }

    get_value() {
        var type = this.type;

        var value = new Object();
        value.field_name = this.id;

        if (type == "checkbox") {
            value.value = this.input.checked ? "1" : "0";
        } else {
            value.value = this.input.value;
        }
        return [value];
    }
}

class TextWidget extends Widget {
    constructor(field, show_label_in) {
        super(show_label_in);
        this.field = field;
        this.id = field.name;
        this.label = field.label;
        this.type = "text";

        this.dom_widget = this.create_widget_dom();

        if (field.translation.validation_error) {
            this.error_message = field.translation.validation_error;
            const error_message = document.createElement("div");
            error_message.id = field.form_id_prefix + "error-message_" + field.name;
            error_message.style.display = "none";
            error_message.innerText = field.translation.validation_error;
            this.dom_widget.appendChild(error_message);
            this.dom_error_message = error_message;
        }
    }
}

class DropdownWidget extends Widget {
    constructor(field, show_label_in) {
        super(show_label_in);
        this.field = field;
        this.id = field.name;
        this.label = field.label;

        this.dom_widget = this.create_widget_dom();

        if (field.translation.validation_error) {
            this.error_message = field.translation.validation_error;
            const error_message = document.createElement("div");
            error_message.id = field.form_id_prefix + "error-message_" + field.name;
            error_message.style.display = "none";
            error_message.innerText = field.translation.validation_error;
            this.dom_widget.appendChild(error_message);
            this.dom_error_message = error_message;
        }
    }

    create_widget_dom() {
        var field = this.field;

        const dom_field = document.createElement("div");
        dom_field.id = field.form_id_prefix + "field_" + field.name;

        const dom_field_label = this.create_label();
        dom_field.appendChild(dom_field_label);

        const dom_field_input = document.createElement("select");
        dom_field_input.classList.add(field.class_name);
        dom_field_input.name = field.name;
        dom_field_input.id = field.form_id_prefix + field.name;
        dom_field.appendChild(dom_field_input);
        this.input = dom_field_input;

        field.options.forEach(function (option) {
            const dom_new_option = document.createElement("option");
            dom_new_option.classList.add(field.class_name);
            dom_new_option.id = field.form_id_prefix + field.name + ":" + option.key;
            dom_new_option.value = option.key;
            dom_new_option.textContent = option.value;

            if ("profile_default_value" in field) {
                if (field.profile_default_value.indexOf(option.key) > -1) {
                    dom_new_option.selected = "selected";
                }
            } else {
                if (field.default_value.indexOf(option.key) > -1) {
                    dom_new_option.selected = "selected";
                }
            }

            dom_field_input.appendChild(dom_new_option);
        }, this);
        return dom_field;
    }
}

class TextAreaWidget extends Widget {
    constructor(field, show_label_in) {
        super(show_label_in);
        this.field = field;
        this.id = field.name;
        this.label = field.label;

        this.dom_widget = this.create_widget_dom();

        if (field.translation.validation_error) {
            this.error_message = field.translation.validation_error;
            const error_message = document.createElement("div");
            error_message.id = field.form_id_prefix + "error-message_" + field.name;
            error_message.style.display = "none";
            error_message.innerText = field.translation.validation_error;
            this.dom_widget.appendChild(error_message);
            this.dom_error_message = error_message;
        }
    }

    create_widget_dom() {
        var field = this.field;

        const dom_field = document.createElement("div");
        dom_field.id = field.form_id_prefix + "field_" + field.name;

        if (this.show_label_in == "both" || this.show_label_in == "label") {
            const dom_field_label = this.create_label();
            dom_field.appendChild(dom_field_label);
        }

        const dom_field_input = document.createElement("textarea");
        dom_field_input.classList.add(field.class_name);
        dom_field_input.name = field.name;
        dom_field_input.id = field.form_id_prefix + field.name;
        if (this.show_label_in == "both" || this.show_label_in == "placeholder") {
            dom_field_input.placeholder = field.label;
        }

        this.input = dom_field_input;

        if ("profile_default_value" in field) {
            dom_field_input.value = field.profile_default_value;
        } else {
            dom_field_input.value = field.default_value;
        }

        if (field.required) {
            dom_field_input.classList.add("mandatory");
        }

        dom_field.appendChild(dom_field_input);

        return dom_field;
    }
}

class CheckboxesWidget extends Widget {
    constructor(field, show_label_in) {
        super(show_label_in);
        this.field = field;
        this.id = field.name;
        this.label = field.label;
        this.type = "checkbox";

        this.dom_widget = this.create_widget_dom();
    }

    create_widget_dom() {
        var field = this.field;

        const dom_field = document.createElement("div");
        dom_field.id = field.form_id_prefix + "field_" + field.name;

        const dom_field_fieldset = document.createElement("fieldset");
        dom_field_fieldset.id = field.form_id_prefix + "fieldset_" + field.name;
        dom_field.appendChild(dom_field_fieldset);

        const dom_field_legend = document.createElement("legend");
        dom_field_legend.id = field.form_id_prefix + "field_legend_" + field.name;
        dom_field_legend.classList.add(field.class_name);
        if (field.required) {
            dom_field_legend.classList.add("mandatory");
        }
        dom_field_legend.innerHTML = field.label;
        dom_field_fieldset.appendChild(dom_field_legend);

        this.input = [];
        field.options.forEach(function (option) {
            const dom_field_option = document.createElement("div");
            dom_field_fieldset.appendChild(dom_field_option);

            const dom_field_input = this.create_input();
            dom_field_option.appendChild(dom_field_input);
            dom_field_input.id = option.key;

            const dom_field_label = document.createElement("label");
            dom_field_label.classList.add(field.class_name);
            dom_field_label.classList.add("checkbox");
            dom_field_label.htmlFor = dom_field_input.name;
            dom_field_option.appendChild(dom_field_label);

            const dom_field_text = document.createElement("span");
            dom_field_text.classList.add(field.class_name);
            dom_field_text.innerHTML = option.value;
            dom_field_label.appendChild(dom_field_text);

            if ("profile_default_value" in field) {
                if (field.profile_default_value.indexOf(option.key) > -1) {
                    dom_field_input.checked = "checked";
                }
            } else {
                if (field.default_value.indexOf(option.key) > -1) {
                    dom_field_input.checked = "checked";
                }
            }

            this.input.push(dom_field_input);
        }, this);

        return dom_field;
    }

    get_value() {
        var value = new Object();
        value.field_name = this.id;
        value.value = [];

        this.input.forEach(function (input) {
            if (input.checked) {
                value.value.push(input.id);
            }
        });

        if (value.value.length == 0) {
            return [];
        }

        return [value];
    }
}

class DateWidget extends Widget {
    constructor(field, show_label_in) {
        super(show_label_in);
        this.field = field;
        this.id = field.name;
        this.label = field.label;
        this.type = "date";

        this.dom_widget = this.create_widget_dom();

        if (field.translation.validation_error) {
            this.error_message = field.translation.validation_error;
            const error_message = document.createElement("div");
            error_message.id = field.form_id_prefix + "error-message_" + field.name;
            error_message.style.display = "none";
            error_message.innerText = field.translation.validation_error;
            this.dom_widget.appendChild(error_message);
            this.dom_error_message = error_message;
        }
    }
}

class DateTimeWidget extends Widget {
    constructor(field, show_label_in) {
        super(show_label_in);
        this.field = field;
        this.id = field.name;
        this.label = field.label;
        this.type = "datetime-local";

        this.dom_widget = this.create_widget_dom();

        if (field.translation.validation_error) {
            this.error_message = field.translation.validation_error;
            const error_message = document.createElement("div");
            error_message.id = field.form_id_prefix + "error-message_" + field.name;
            error_message.style.display = "none";
            error_message.innerText = field.translation.validation_error;
            this.dom_widget.appendChild(error_message);
            this.dom_error_message = error_message;
        }
    }
}

class TextTrimWidget extends Widget {
    constructor(field, show_label_in) {
        super(show_label_in);
        this.field = field;
        this.id = field.name;
        this.label = field.label;
        this.type = "text";

        this.dom_widget = this.create_widget_dom();

        if (field.translation.validation_error) {
            this.error_message = field.translation.validation_error;
            const error_message = document.createElement("div");
            error_message.id = field.form_id_prefix + "error-message_" + field.name;
            error_message.style.display = "none";
            error_message.innerText = field.translation.validation_error;
            this.dom_widget.appendChild(error_message);
            this.dom_error_message = error_message;
        }
    }
}

class RadioButtonsWidget extends Widget {
    constructor(field, show_label_in) {
        super(show_label_in);
        this.field = field;
        this.id = field.name;
        this.label = field.label;
        this.type = "radio";

        this.dom_widget = this.create_widget_dom();

        if (field.translation.validation_error) {
            this.error_message = field.translation.validation_error;
            const error_message = document.createElement("div");
            error_message.id = field.form_id_prefix + "error-message_" + field.name;
            error_message.style.display = "none";
            error_message.innerText = field.translation.validation_error;
            this.dom_widget.appendChild(error_message);
            this.dom_error_message = error_message;
        }
    }

    create_widget_dom() {
        var field = this.field;

        const dom_field = document.createElement("div");
        dom_field.id = field.form_id_prefix + "field_" + field.name;

        const dom_field_fieldset = document.createElement("fieldset");
        dom_field_fieldset.id = field.form_id_prefix + "fieldset_" + field.name;
        dom_field.appendChild(dom_field_fieldset);

        const dom_field_legend = document.createElement("legend");
        dom_field_legend.id = field.form_id_prefix + "field_legend_" + field.name;
        dom_field_legend.classList.add(field.class_name);
        if (field.required) {
            dom_field_legend.classList.add("mandatory");
        }
        dom_field_legend.innerHTML = field.label;
        dom_field_fieldset.appendChild(dom_field_legend);

        this.input = [];

        field.options.forEach(function (option) {
            const dom_field_option = document.createElement("div");
            dom_field_fieldset.appendChild(dom_field_option);

            const dom_field_input_option = this.create_input();
            dom_field_input_option.value = option.key;
            dom_field_input_option.id = field.form_id_prefix + field.name + ":" + option.key;
            dom_field_input_option.name = field.name;
            dom_field_option.appendChild(dom_field_input_option);
            this.input.push(dom_field_input_option);

            const dom_field_label = document.createElement("label");
            dom_field_label.classList.add(field.class_name);
            dom_field_label.classList.add("radio");
            dom_field_label.htmlFor = dom_field_input_option.name;
            dom_field_option.appendChild(dom_field_label);

            const dom_field_text = document.createElement("span");
            dom_field_text.classList.add(field.class_name);
            dom_field_text.innerHTML = option.value;
            dom_field_label.appendChild(dom_field_text);

            if ("profile_default_value" in field) {
                if (field.profile_default_value.indexOf(option.key) > -1) {
                    dom_field_input_option.checked = "checked";
                }
            } else {
                if (field.default_value.indexOf(option.key) > -1) {
                    dom_field_input_option.checked = "checked";
                }
            }
        }, this);

        return dom_field;
    }

    get_value() {
        var output = [];

        this.input.forEach(function (input) {
            if (input.checked) {
                var value = new Object();
                value.field_name = input.name;
                value.value = input.value;
                output.push(value);
            }
        });

        return output;
    }
}

class ReadOnlyWidget extends Widget {
    constructor(field, show_label_in) {
        super(show_label_in);
        this.field = field;
        this.id = field.name;
        this.label = field.label;

        this.dom_widget = this.create_widget_dom();

        if (field.translation.validation_error) {
            this.error_message = field.translation.validation_error;
            const error_message = document.createElement("div");
            error_message.id = field.form_id_prefix + "error-message_" + field.name;
            error_message.style.display = "none";
            error_message.innerText = field.translation.validation_error;
            this.dom_widget.appendChild(error_message);
            this.dom_error_message = error_message;
        }
    }

    create_widget_dom() {
        var field = this.field;

        const dom_field = document.createElement("div");
        dom_field.id = field.form_id_prefix + "field_" + field.name;
        dom_field.readOnly = true;

        const dom_field_label = this.create_label();
        dom_field.appendChild(dom_field_label);

        var dom_field_input = null;
        if ("profile_default_value" in field) {
            dom_field_input = document.createTextNode(field.profile_default_value_readonly);
            //dom_field_input = document.createTextNode(field.profile_default_value);
        } else {
            dom_field_input = document.createTextNode(field.default_value);
        }

        dom_field.appendChild(dom_field_input);

        return dom_field;
    }

    get_value() {
        return [];
    }
}

class TextTitleCaseWidget extends Widget {
    constructor(field, show_label_in) {
        super(show_label_in);
        this.field = field;
        this.id = field.name;
        this.label = field.label;
        this.type = "text";

        this.dom_widget = this.create_widget_dom();

        if (field.translation.validation_error) {
            this.error_message = field.translation.validation_error;
            const error_message = document.createElement("div");
            error_message.id = field.form_id_prefix + "error-message_" + field.name;
            error_message.style.display = "none";
            error_message.innerText = field.translation.validation_error;
            this.dom_widget.appendChild(error_message);
            this.dom_error_message = error_message;
        }
    }
}

class PasswordWidget extends Widget {
    constructor(field, show_label_in) {
        super(show_label_in);
        this.field = field;
        this.id = field.name;
        this.label = field.label;
        this.type = "password";

        this.dom_widget = this.create_widget_dom();

        if (field.translation.validation_error) {
            this.error_message = field.translation.validation_error;
            const error_message = document.createElement("div");
            error_message.id = field.form_id_prefix + "error-message_" + field.name;
            error_message.style.display = "none";
            error_message.innerText = field.translation.validation_error;
            this.dom_widget.appendChild(error_message);
            this.dom_error_message = error_message;
        }
    }

    create_widget_dom() {
        var field = this.field;

        const dom_field = document.createElement("div");
        dom_field.id = field.form_id_prefix + "field_" + field.name;

        const dom_field_label = this.create_label();
        dom_field.appendChild(dom_field_label);

        const dom_field_input = this.create_input();
        dom_field.appendChild(dom_field_input);
        this.input = dom_field_input;

        return dom_field;
    }
}

class PasswordGeneratorWidget extends Widget {
    constructor(field, show_label_in) {
        super(show_label_in);
        this.field = field;
        this.id = field.name;
        this.label = field.label;
        this.type = "text";

        this.dom_widget = this.create_widget_dom();

        if (field.translation.validation_error) {
            this.error_message = field.translation.validation_error;
            const error_message = document.createElement("div");
            error_message.id = field.form_id_prefix + "error-message_" + field.name;
            error_message.style.display = "none";
            error_message.innerText = field.translation.validation_error;
            this.dom_widget.appendChild(error_message);
            this.dom_error_message = error_message;
        }
    }
}

class DateFutureWidget extends Widget {
    constructor(field, show_label_in) {
        super(show_label_in);
        this.field = field;
        this.id = field.name;
        this.label = field.label;
        this.type = "date";

        this.dom_widget = this.create_widget_dom();

        if (field.translation.validation_error) {
            this.error_message = field.translation.validation_error;
            const error_message = document.createElement("div");
            error_message.id = field.form_id_prefix + "error-message_" + field.name;
            error_message.style.display = "none";
            error_message.innerText = field.translation.validation_error;
            this.dom_widget.appendChild(error_message);
            this.dom_error_message = error_message;
        }
    }

    create_input() {
        const dom_field = super.create_input();
        var now = new Date();
        dom_field.setAttribute("min", now.toISOString().substring(0, 10));

        return dom_field;
    }
}

class DateTimeFutureWidget extends Widget {
    constructor(field, show_label_in) {
        super(show_label_in);
        this.field = field;
        this.id = field.name;
        this.label = field.label;
        this.type = "datetime-local";

        this.dom_widget = this.create_widget_dom();

        if (field.translation.validation_error) {
            this.error_message = field.translation.validation_error;
            const error_message = document.createElement("div");
            error_message.id = field.form_id_prefix + "error-message_" + field.name;
            error_message.style.display = "none";
            error_message.innerText = field.translation.validation_error;
            this.dom_widget.appendChild(error_message);
            this.dom_error_message = error_message;
        }
    }

    create_input() {
        const dom_field = super.create_input();
        var now = new Date();
        dom_field.setAttribute("min", now.toISOString().substring(0, 16).replace("T", " "));

        return dom_field;
    }
}

class CheckboxWidget extends Widget {
    constructor(field, show_label_in) {
        super(show_label_in);
        this.field = field;
        this.id = field.name;
        this.label = field.label;
        this.type = "checkbox";

        this.dom_widget = this.create_widget_dom();

        if (field.translation.validation_error) {
            this.error_message = field.translation.validation_error;
            const error_message = document.createElement("div");
            error_message.id = field.form_id_prefix + "error-message_" + field.name;
            error_message.style.display = "none";
            error_message.innerText = field.translation.validation_error;
            this.dom_widget.appendChild(error_message);
            this.dom_error_message = error_message;
        }
    }

    create_widget_dom() {
        var field = this.field;

        const dom_field = document.createElement("div");
        dom_field.id = field.form_id_prefix + "field_" + field.name;

        const dom_field_input = this.create_input();
        dom_field.appendChild(dom_field_input);
        this.input = dom_field_input;

        const dom_field_label = this.create_label();
        dom_field.appendChild(dom_field_label);

        return dom_field;
    }
}

class TextBlankWidget extends Widget {
    constructor(field, show_label_in) {
        super(show_label_in);
        this.field = field;
        this.id = field.name;
        this.label = field.label;
        this.type = "text";

        this.dom_widget = this.create_widget_dom();

        if (field.translation.validation_error) {
            this.error_message = field.translation.validation_error;
            const error_message = document.createElement("div");
            error_message.id = field.form_id_prefix + "error-message_" + field.name;
            error_message.style.display = "none";
            error_message.innerText = field.translation.validation_error;
            this.dom_widget.appendChild(error_message);
            this.dom_error_message = error_message;
        }
    }
}

class TextSingleSelectionWidget extends Widget {
    constructor(field, show_label_in) {
        super(show_label_in);
        this.field = field;
        this.id = field.name;
        this.label = field.label;
        this.type = "text";

        this.dom_widget = this.create_widget_dom();

        if (field.translation.validation_error) {
            this.error_message = field.translation.validation_error;
            const error_message = document.createElement("div");
            error_message.id = field.form_id_prefix + "error-message_" + field.name;
            error_message.style.display = "none";
            error_message.innerText = field.translation.validation_error;
            this.dom_widget.appendChild(error_message);
            this.dom_error_message = error_message;
        }
    }
}

class DropdownZeroOptionWidget extends Widget {
    constructor(field, show_label_in) {
        super(show_label_in);
        this.field = field;
        this.id = field.name;
        this.label = field.label;

        this.dom_widget = this.create_widget_dom();

        if (field.translation.validation_error) {
            this.error_message = field.translation.validation_error;
            const error_message = document.createElement("div");
            error_message.id = field.form_id_prefix + "error-message_" + field.name;
            error_message.style.display = "none";
            error_message.innerText = field.translation.validation_error;
            this.dom_widget.appendChild(error_message);
            this.dom_error_message = error_message;
        }
    }

    create_widget_dom() {
        var field = this.field;

        const dom_field = document.createElement("div");
        dom_field.id = field.form_id_prefix + "field_" + field.name;

        const dom_field_label = this.create_label();
        dom_field.appendChild(dom_field_label);

        const dom_field_input = document.createElement("select");
        dom_field_input.classList.add(field.class_name);
        dom_field_input.name = field.name;
        dom_field_input.id = field.form_id_prefix + field.name;
        dom_field.appendChild(dom_field_input);
        this.input = dom_field_input;

        field.options.forEach(function (option) {
            const dom_new_option = document.createElement("option");
            dom_new_option.classList.add(field.class_name);
            dom_new_option.id = field.form_id_prefix + field.name + ":" + option.key;
            dom_new_option.value = option.key;
            dom_new_option.textContent = option.value;

            if ("profile_default_value" in field) {
                if (field.profile_default_value.indexOf(option.key) > -1) {
                    dom_new_option.selected = "selected";
                }
            } else {
                if (field.default_value.indexOf(option.key) > -1) {
                    dom_new_option.selected = "selected";
                }
            }

            dom_field_input.appendChild(dom_new_option);
        }, this);
        return dom_field;
    }
}

class RadioButtonsZeroOptionWidget extends Widget {
    constructor(field, show_label_in) {
        super(show_label_in);
        this.field = field;
        this.id = field.name;
        this.label = field.label;
        this.type = "radio";

        this.dom_widget = this.create_widget_dom();

        if (field.translation.validation_error) {
            this.error_message = field.translation.validation_error;
            const error_message = document.createElement("div");
            error_message.id = field.form_id_prefix + "error-message_" + field.name;
            error_message.style.display = "none";
            error_message.innerText = field.translation.validation_error;
            this.dom_widget.appendChild(error_message);
            this.dom_error_message = error_message;
        }
    }
    create_widget_dom() {
        var field = this.field;

        const dom_field = document.createElement("div");
        dom_field.id = field.form_id_prefix + "field_" + field.name;

        const dom_field_fieldset = document.createElement("fieldset");
        dom_field_fieldset.id = field.form_id_prefix + "fieldset_" + field.name;
        dom_field.appendChild(dom_field_fieldset);

        const dom_field_legend = document.createElement("legend");
        dom_field_legend.id = field.form_id_prefix + "field_legend_" + field.name;
        dom_field_legend.classList.add(field.class_name);
        if (field.required) {
            dom_field_legend.classList.add("mandatory");
        }
        dom_field_legend.innerHTML = field.label;
        dom_field_fieldset.appendChild(dom_field_legend);

        this.input = [];

        var null_radio_option = this.create_radio_option(0, "-");
        dom_field_fieldset.appendChild(null_radio_option);

        field.options.forEach(function (option) {
            const dom_field_option = this.create_radio_option(option.key, option.value);
            dom_field_fieldset.appendChild(dom_field_option);
        }, this);

        return dom_field;
    }

    get_value() {
        var output = [];

        this.input.forEach(function (input) {
            if (input.checked) {
                var value = new Object();
                value.field_name = input.name;
                value.value = input.value;
                output.push(value);
            }
        });

        return output;
    }
}

class TextLowerCaseWidget extends Widget {
    constructor(field, show_label_in) {
        super(show_label_in);
        this.field = field;
        this.id = field.name;
        this.label = field.label;
        this.type = "text";

        this.dom_widget = this.create_widget_dom();

        if (field.translation.validation_error) {
            this.error_message = field.translation.validation_error;
            const error_message = document.createElement("div");
            error_message.id = field.form_id_prefix + "error-message_" + field.name;
            error_message.style.display = "none";
            error_message.innerText = field.translation.validation_error;
            this.dom_widget.appendChild(error_message);
            this.dom_error_message = error_message;
        }
    }
}

class TextUpperCaseWidget extends Widget {
    constructor(field, show_label_in) {
        super(show_label_in);
        this.field = field;
        this.id = field.name;
        this.label = field.label;
        this.type = "text";

        this.dom_widget = this.create_widget_dom();

        if (field.translation.validation_error) {
            this.error_message = field.translation.validation_error;
            const error_message = document.createElement("div");
            error_message.id = field.form_id_prefix + "error-message_" + field.name;
            error_message.style.display = "none";
            error_message.innerText = field.translation.validation_error;
            this.dom_widget.appendChild(error_message);
            this.dom_error_message = error_message;
        }
    }
}

class DatePastWidget extends Widget {
    constructor(field, show_label_in) {
        super(show_label_in);
        this.field = field;
        this.id = field.name;
        this.label = field.label;
        this.type = "date";

        this.dom_widget = this.create_widget_dom();

        if (field.translation.validation_error) {
            this.error_message = field.translation.validation_error;
            const error_message = document.createElement("div");
            error_message.id = field.form_id_prefix + "error-message_" + field.name;
            error_message.style.display = "none";
            error_message.innerText = field.translation.validation_error;
            this.dom_widget.appendChild(error_message);
            this.dom_error_message = error_message;
        }
    }

    create_input() {
        const dom_field = super.create_input();
        var now = new Date();
        dom_field.setAttribute("max", now.toISOString().substring(0, 10));

        return dom_field;
    }
}

class DateTimePastWidget extends Widget {
    constructor(field, show_label_in) {
        super(show_label_in);
        this.field = field;
        this.id = field.name;
        this.label = field.label;
        this.type = "datetime-local";

        this.dom_widget = this.create_widget_dom();

        if (field.translation.validation_error) {
            this.error_message = field.translation.validation_error;
            const error_message = document.createElement("div");
            error_message.id = field.form_id_prefix + "error-message_" + field.name;
            error_message.style.display = "none";
            error_message.innerText = field.translation.validation_error;
            this.dom_widget.appendChild(error_message);
            this.dom_error_message = error_message;
        }
    }

    create_input() {
        const dom_field = super.create_input();
        var now = new Date();
        dom_field.setAttribute("max", now.toISOString().substring(0, 16).replace("T", " "));

        return dom_field;
    }
}

class TextAreaBlankWidget extends Widget {
    constructor(field, show_label_in) {
        super(show_label_in);
        this.field = field;
        this.id = field.name;
        this.label = field.label;

        this.dom_widget = this.create_widget_dom();

        if (field.translation.validation_error) {
            this.error_message = field.translation.validation_error;
            const error_message = document.createElement("div");
            error_message.id = field.form_id_prefix + "error-message_" + field.name;
            error_message.style.display = "none";
            error_message.innerText = field.translation.validation_error;
            this.dom_widget.appendChild(error_message);
            this.dom_error_message = error_message;
        }
    }

    create_widget_dom() {
        var field = this.field;

        const dom_field = document.createElement("div");
        dom_field.id = field.form_id_prefix + "field_" + field.name;

        if (this.show_label_in == "both" || this.show_label_in == "label") {
            const dom_field_label = this.create_label();
            dom_field.appendChild(dom_field_label);
        }

        const dom_field_input = document.createElement("textarea");
        dom_field_input.classList.add(field.class_name);
        dom_field_input.name = field.name;
        dom_field_input.id = field.form_id_prefix + field.name;

        if (this.show_label_in == "both" || this.show_label_in == "placeholder") {
            dom_field_input.placeholder = field.label;
        }

        this.input = dom_field_input;

        if ("profile_default_value" in field) {
            dom_field_input.value = field.profile_default_value;
        } else {
            dom_field_input.value = field.default_value;
        }

        if (field.required) {
            dom_field_input.classList.add("mandatory");
        }

        dom_field.appendChild(dom_field_input);

        return dom_field;
    }
}

class CheckboxesAppendWidget extends Widget {
    constructor(field, show_label_in) {
        super(show_label_in);
        this.field = field;
        this.id = field.name;
        this.label = field.label;
        this.type = "checkbox";

        this.dom_widget = this.create_widget_dom();

        if (field.translation.validation_error) {
            this.error_message = field.translation.validation_error;
            const error_message = document.createElement("div");
            error_message.id = field.form_id_prefix + "error-message_" + field.name;
            error_message.style.display = "none";
            error_message.innerText = field.translation.validation_error;
            this.dom_widget.appendChild(error_message);
            this.dom_error_message = error_message;
        }
    }

    create_widget_dom() {
        var field = this.field;

        const dom_field = document.createElement("div");
        dom_field.id = field.form_id_prefix + "field_" + field.name;

        const dom_field_fieldset = document.createElement("fieldset");
        dom_field_fieldset.id = field.form_id_prefix + "fieldset_" + field.name;
        dom_field.appendChild(dom_field_fieldset);

        const dom_field_legend = document.createElement("legend");
        dom_field_legend.id = field.form_id_prefix + "field_legend_" + field.name;
        dom_field_legend.classList.add(field.class_name);
        if (field.required) {
            dom_field_legend.classList.add("mandatory");
        }
        dom_field_legend.innerHTML = field.label;
        dom_field_fieldset.appendChild(dom_field_legend);

        this.input = [];
        field.options.forEach(function (option) {
            const dom_field_option = document.createElement("div");
            dom_field_fieldset.appendChild(dom_field_option);

            const dom_field_input = this.create_input();
            dom_field_option.appendChild(dom_field_input);
            dom_field_input.id = option.key;

            const dom_field_label = document.createElement("label");
            dom_field_label.classList.add(field.class_name);
            dom_field_label.classList.add("checkbox");
            dom_field_label.htmlFor = dom_field_input.name;
            dom_field_option.appendChild(dom_field_label);

            const dom_field_text = document.createElement("span");
            dom_field_text.innerHTML = option.value;
            dom_field_label.appendChild(dom_field_text);

            if ("profile_default_value" in field) {
                if (field.profile_default_value.indexOf(option.key) > -1) {
                    dom_field_input.checked = "checked";
                }
            } else {
                if (field.default_value.indexOf(option.key) > -1) {
                    dom_field_input.checked = "checked";
                }
            }

            this.input.push(dom_field_input);
        }, this);

        return dom_field;
    }

    get_value() {
        var value = new Object();
        value.field_name = this.id;
        value.value = [];

        this.input.forEach(function (input) {
            if (input.checked) {
                value.value.push(input.id);
            }
        });

        if (value.value.length == 0) {
            return [];
        }

        return [value];
    }
}

class DateStringToDateWidget extends Widget {
    constructor(field, show_label_in) {
        super(show_label_in);
        this.field = field;
        this.id = field.name;
        this.label = field.label;
        this.type = "date";

        this.dom_widget = this.create_widget_dom();

        if (field.translation.validation_error) {
            this.error_message = field.translation.validation_error;
            const error_message = document.createElement("div");
            error_message.id = field.form_id_prefix + "error-message_" + field.name;
            error_message.style.display = "none";
            error_message.innerText = field.translation.validation_error;
            this.dom_widget.appendChild(error_message);
            this.dom_error_message = error_message;
        }
    }
}

class DateTimeStringToTimeWidget extends Widget {
    constructor(field, show_label_in) {
        super(show_label_in);
        this.field = field;
        this.id = field.name;
        this.label = field.label;
        this.type = "datetime-local";

        this.dom_widget = this.create_widget_dom();

        if (field.translation.validation_error) {
            this.error_message = field.translation.validation_error;
            const error_message = document.createElement("div");
            error_message.id = field.form_id_prefix + "error-message_" + field.name;
            error_message.style.display = "none";
            error_message.innerText = field.translation.validation_error;
            this.dom_widget.appendChild(error_message);
            this.dom_error_message = error_message;
        }
    }
}

class CheckboxInvertedWidget extends Widget {
    constructor(field, show_label_in) {
        super(show_label_in);
        this.field = field;
        this.id = field.name;
        this.label = field.label;
        this.type = "checkbox";

        this.dom_widget = this.create_widget_dom();

        if (field.translation.validation_error) {
            this.error_message = field.translation.validation_error;
            const error_message = document.createElement("div");
            error_message.id = field.form_id_prefix + "error-message_" + field.name;
            error_message.style.display = "none";
            error_message.innerText = field.translation.validation_error;
            this.dom_widget.appendChild(error_message);
            this.dom_error_message = error_message;
        }
    }

    create_widget_dom() {
        var field = this.field;

        const dom_field = document.createElement("div");
        dom_field.id = field.form_id_prefix + "field_" + field.name;

        const dom_field_input = this.create_input();
        dom_field_input.checked = dom_field_input.checked ? false : true;
        dom_field.appendChild(dom_field_input);
        this.input = dom_field_input;

        const dom_field_label = this.create_label();
        dom_field.appendChild(dom_field_label);

        return dom_field;
    }

    get_value() {
        var type = this.type;

        var value = new Object();
        value.field_name = this.id;
        value.value = this.input.checked ? "0" : "1";

        return [value];
    }
}

class TextFilteredWidget extends Widget {
    constructor(field, show_label_in) {
        super(show_label_in);
        this.field = field;
        this.id = field.name;
        this.label = field.label;
        this.type = "text";

        this.dom_widget = this.create_widget_dom();

        if (field.translation.validation_error) {
            this.error_message = field.translation.validation_error;
            const error_message = document.createElement("div");
            error_message.id = field.form_id_prefix + "error-message_" + field.name;
            error_message.style.display = "none";
            error_message.innerText = field.translation.validation_error;
            this.dom_widget.appendChild(error_message);
            this.dom_error_message = error_message;
        }

        this.input.maxlength = 45;
    }
}

class TextFilteredBlankWidget extends Widget {
    constructor(field, show_label_in) {
        super(show_label_in);
        this.field = field;
        this.id = field.name;
        this.label = field.label;
        this.type = "text";

        this.dom_widget = this.create_widget_dom();

        if (field.translation.validation_error) {
            this.error_message = field.translation.validation_error;
            const error_message = document.createElement("div");
            error_message.id = field.form_id_prefix + "error-message_" + field.name;
            error_message.style.display = "none";
            error_message.innerText = field.translation.validation_error;
            this.dom_widget.appendChild(error_message);
            this.dom_error_message = error_message;
        }

        this.input.maxlength = 45;
    }
}

class SmartForm {
    constructor(config) {
        if (!config.interface_domain.startsWith("https://")) {
            config.interface_domain = "https://" + config.interface_domain;
        }
        if (!config.interface_domain.endsWith("/")) {
            config.interface_domain = config.interface_domain + "/";
        }

        this.interface_domain = config.interface_domain;
        this.form_sid = config.form_sid;
        this.form_container_id = config.form_container_id || "form_container";
        this.form_id_prefix = config.form_id_prefix || "";
        this.class_name = config.class_name || "SmartForm";
        this.force_new_profile = config.force_new_profile || false;
        this.allow_empty_profile = config.allow_empty_profile || false;
        this.form_url = this.interface_domain + "api/form/v2/" + this.form_sid;
        this.test = config.test || false;
        this.url_profileid_parameter = config.url_profileid_parameter || false;
        this.profile_id = config.profile_id || "";
        this.show_label_in = config.show_label_in || "both";

        if (this.url_profileid_parameter && window.location.search.includes(this.url_profileid_parameter + "=")) {
            let regexp = new RegExp(String.raw`${this.url_profileid_parameter}=([a-z0-9]*)`, "g");
            const array = (this.profile_id = [...window.location.search.matchAll(regexp)][0][1]);
        }
    }

    async get_form_data() {
        let response = await fetch(this.form_url + (this.profile_id ? "?u=" + this.profile_id : ""), {
            method: "GET",
            headers: {
                Origin: this.interface_domain,
                "Content-Type": "application/json",
            },
        });

        this.response_json = await response.json();

        if (this.response_json.profile) {
            if ("data" in this.response_json.profile && this.response_json.profile.data.length > 0) {
                let profile_data = {};
                this.response_json.profile.data.forEach(function (data) {
                    // reconstruct the profil-data structure for better accessability
                    let { name, ...rest } = data;
                    profile_data[name] = rest;
                });
                this.response_json.profile.data = profile_data;
            }
        }

        this.use_captcha = this.response_json.captcha != null;

        this.render_form();
    }

    async renewToken() {
        let response = await fetch(this.form_url, {
            method: "GET",
            headers: {
                Origin: this.interface_domain,
                "Content-Type": "application/json",
            },
        });

        let response_json = await response.json();
        return response_json.token;
    }

    async handleFormSubmit(event) {
        var submit_request = this.collect_form_values(event.currentTarget.smartform);
        submit_request.token = this.response_json.token;
        submit_request.token = await this.renewToken();

        if (this.use_captcha) {
            submit_request.captcha_response = document.querySelectorAll("input[name='g-recaptcha-response']")[0].value;
        } else {
            submit_request.captcha_response = "";
        }

        if (this.test) {
            console.log(submit_request);
        }

        this.dom_form_error.innerHTML = "";
        this.fields.forEach(function (field) {
            if (Object.hasOwn(field, "input")) {
                if (Array.isArray(field.input)) {
                    field.input.forEach(function (input) {
                        if (input.classList.contains("validation_error")) {
                            input.classList.remove("validation_error");
                        }
                    });
                } else {
                    if (field.input.classList.contains("validation_error")) {
                        field.input.classList.remove("validation_error");
                    }
                    if (field.dom_label.classList.contains("validation_error")) {
                        field.dom_label.classList.remove("validation_error");
                    }
                }
            }

            if (Object.hasOwn(field, "dom_error_message")) {
                field.dom_error_message.style.display = "none";
            }
        });

        let response = await fetch(this.form_url, {
            method: "POST",
            body: JSON.stringify(submit_request),
            headers: { Origin: this.interface_domain, "Content-Type": "application/json" },
        });
        var result = await response.json();
        console.log(result);

        if (Object.hasOwn(result, "error")) {
            this.dom_form_error.style.display = "block";
            console.log(result.error);
            switch (result.error.code) {
                case 101:
                    this.validation_error_missing_profile();
                    break;
                case 102:
                    this.validation_error(result.error.validation_error_attributes);
                    break;
                case 103:
                    this.validation_error_failed_login();
                    break;
                case 104:
                    this.validation_error_dublicate_error();
                    break;
                case 105:
                    this.validation_error_submission_limit();
                    break;
                case 106:
                    this.validation_error_mandatory_error(result.error.mandatory_error_attributes);
                    break;
                case 107:
                    this.validation_error_invalid_request();
                    break;
                case 108:
                    this.validation_error_empty_profile();
                    break;
                default:
                    console.log("missing error code: " & result.error.code);
            }

            document.getElementById("form_error").scrollIntoView();
        } else {
            result.result.redirection_url = result.result.redirection_url.replace(/\{\$([^\}]+)\}/gi, (match, $1) => {
                if ("form_" + $1 in result.result.profile.data) {
                    return result.result.profile.data["form_" + $1]["value"];
                } else if ($1 == "UID") {
                    return result.result.profile.uid;
                } else {
                    console.log("Missing replacement variable: " + match);
                    return match;
                }
            });

            if (this.test) {
                console.log(result.result.redirection_url);
            } else {
                window.location.href = result.result.redirection_url;
            }
        }
    }

    validation_error_missing_profile() {
        var missing_profile_error = document.createElement("div");
        missing_profile_error.id = this.form_id_prefix + "form_missing_profile_error";
        missing_profile_error.innerText = this.translations.failed_validation;
        this.dom_form_error.appendChild(missing_profile_error);
    }

    validation_error(validation_error_attributes) {
        var validation_error = document.createElement("div");
        validation_error.id = this.form_id_prefix + "validation_error";
        validation_error.innerText = this.translations.preface_validation;

        var validation_error_fields = document.createElement("ul");
        validation_error_fields.classList.add(this.class_name);
        validation_error.appendChild(validation_error_fields);

        this.fields.forEach(function (field) {
            if (validation_error_attributes.includes(field.id)) {
                field.set_validation_error();

                var validation_error_field = document.createElement("li");
                validation_error_field.classList.add(field.class_name);
                validation_error_field.innerText = field.label;
                validation_error_fields.appendChild(validation_error_field);
            }
        });

        this.dom_form_error.appendChild(validation_error);
    }

    validation_error_failed_login() {
        var login_error = document.createElement("div");
        login_error.id = this.form_id_prefix + "login_error";
        login_error.innerText = this.translations.failed_validation;
        this.dom_form_error.appendChild(login_error);
    }

    validation_error_dublicate_error() {
        var dublicate_error = document.createElement("div");
        dublicate_error.id = this.form_id_prefix + "dublicate_error";
        dublicate_error.innerText = this.translations.duplicate_validation;
        this.dom_form_error.appendChild(dublicate_error);
    }

    validation_error_submission_limit() {
        var submission_limit_error = document.createElement("div");
        submission_limit_error.id = this.form_id_prefix + "submission_limit_error";
        submission_limit_error.innerText = "";
        //TODO: Missing Error Message
        this.dom_form_error.appendChild(submission_limit_error);
    }

    validation_error_mandatory_error(mandatory_error_attributes) {
        var mandatory_error = document.createElement("div");
        mandatory_error.id = this.form_id_prefix + "mandatory_error";

        var mandatory_error_message = document.createElement("span");
        mandatory_error_message.classList.add(this.class_name);
        mandatory_error_message.id = this.form_id_prefix + "mandatory_error_message";
        mandatory_error_message.classList.add("validation_message");
        mandatory_error_message.innerText = this.translations.preface_validation;
        mandatory_error.appendChild(mandatory_error_message);

        var mandatory_error_fields = document.createElement("ul");
        mandatory_error_fields.classList.add(this.class_name);
        mandatory_error.appendChild(mandatory_error_fields);

        this.fields.forEach(function (field) {
            if (mandatory_error_attributes.includes(field.id)) {
                field.set_validation_error();

                var mandatory_error_field = document.createElement("li");
                mandatory_error_field.classList.add(field.class_name);
                mandatory_error_field.innerText = field.label;
                mandatory_error_fields.appendChild(mandatory_error_field);
            }
        });
        this.dom_form_error.appendChild(mandatory_error);
    }

    validation_error_invalid_request() {
        var invalid_request = document.createElement("div");
        invalid_request.id = this.form_id_prefix + "invalid_request";
        invalid_request.innerText = "";
        //TODO: Missing Error Message
        this.dom_form_error.appendChild(invalid_request);
    }

    validation_error_empty_profile() {
        var empty_profile = document.createElement("div");
        empty_profile.id = this.form_id_prefix + "empty_profile";
        empty_profile.innerText = "";
        //TODO: Missing Error Message
        this.dom_form_error.appendChild(empty_profile);
    }

    collect_form_values(form) {
        const submit_request = new Object();
        submit_request.profile_uid = form.profile_id;

        submit_request.data = [];
        form.fields.forEach(function (field) {
            var value = field.get_value();
            if (value) {
                submit_request.data = submit_request.data.concat(value);
            }
        }, form);

        submit_request.options = {
            force_new_profile: form.force_new_profile,
            allow_empty_profile: form.allow_empty_profile,
        };

        return submit_request;
    }

    render_form() {
        let data = this.response_json;

        if (data.profile == null) {
            this.profile_id = "";
        }

        this.dom_form_container = document.getElementById(this.form_container_id);

        if (data.form.title) {
            this.dom_form_title = document.createElement("h1");
            this.dom_form_title.classList.add(this.class_name);
            this.dom_form_title.id = this.form_id_prefix + "form_title";
            this.dom_form_title.textContent = data.form.title;
            this.dom_form_container.appendChild(this.dom_form_title);
        }
        if (data.form.shorttext) {
            this.dom_form_short_description = document.createElement("div");
            this.dom_form_short_description.id = this.form_id_prefix + "shorttext";
            this.dom_form_short_description.innerHTML = data.form.shorttext;
            this.dom_form_container.appendChild(this.dom_form_short_description);
        }

        this.dom_form_error = document.createElement("div");
        this.dom_form_error.id = this.form_id_prefix + "form_error";
        this.dom_form_error.style.display = "none";
        this.dom_form_container.appendChild(this.dom_form_error);

        this.translations = data.form.translation;

        this.dom_form = document.createElement("form");
        this.dom_form.classList.add(this.class_name);
        this.dom_form.smartform = this;
        this.dom_form.id = this.form_id_prefix + "form";
        this.dom_form.autocomplete = "on";

        var smartform = this;
        this.dom_form.addEventListener("submit", function (event) {
            event.preventDefault();
            smartform.handleFormSubmit(event);
        });
        this.dom_form_container.appendChild(this.dom_form);

        this.dom_form_body = document.createElement("div");
        this.dom_form_body.id = this.form_id_prefix + "form_body";
        this.dom_form.appendChild(this.dom_form_body);

        var fields = document.createElement("div");
        fields.id = this.form_id_prefix + "formfields";
        this.dom_form_body.appendChild(fields);

        this.dom_rows = [];
        this.dom_cols = [];
        this.fields = [];

        data.fields.forEach(function (field) {
            field.form_id_prefix = this.form_id_prefix;
            field.class_name = this.class_name;

            if (field.hidden) {
                return;
            }

            if (field.type == "date") {
                field.default_date = new Date(parseInt(field.default_value) * 1000);
            }
            if (this.response_json.profile != null && "data" in this.response_json.profile) {
                if (field.name in this.response_json.profile.data) {
                    //console.log('ok')
                    field.profile_default_value = this.response_json.profile.data[field.name].value;
                    if (field.type == "date") {
                        field.default_date = new Date(parseInt(this.response_json.profile.data[field.name].value) * 1000);
                    }
                }
                if (field.options.length > 0) {
                    let field_options = {};
                    field.options.forEach(function (data) {
                        let { key, ...rest } = data;
                        field_options[key] = rest;
                        //field.profile_default_value = field.options.
                    });
                    //field.options =
                    field.profile_default_value_readonly = field_options[field.profile_default_value].value;
                }
            }


            while (this.dom_rows.length <= field.sort) {
                let new_row = document.createElement("div");
                new_row.id = this.form_id_prefix + "form_row-" + this.dom_rows.length;
                new_row.style.display = "none";
                new_row.classList.add("form_row");
                fields.appendChild(new_row);
                this.dom_rows.push(new_row);
                this.dom_cols.push([]);
            }

            let new_col = document.createElement("div");
            new_col.id = this.form_id_prefix + "form_col-" + field.sort + "-" + this.dom_cols[field.sort].length;
            new_col.classList.add("form_col");

            const new_field = this.create_widgets(field);
            if (new_field) {
                new_col.appendChild(new_field.dom);
                this.fields.push(new_field);
            }

            this.dom_rows[field.sort].appendChild(new_col);
            this.dom_rows[field.sort].style.removeProperty("display");
            this.dom_cols[field.sort].push(new_col);
        }, this);

        if (this.response_json.captcha != null) {
            const dom_div_captcha = document.createElement("div");
            dom_div_captcha.id = "captcha";
            this.dom_form_body.appendChild(dom_div_captcha);

            this.createCaptcha(dom_div_captcha, this.response_json.captcha);
        }

        const dom_div_submit = document.createElement("div");
        dom_div_submit.id = this.form_id_prefix + "actions";
        const dom_input_submit = document.createElement("input");
        dom_input_submit.classList.add(this.class_name);
        dom_input_submit.type = "submit";
        dom_input_submit.classList.add("submit");
        dom_input_submit.id = this.form_id_prefix + "submit";
        dom_input_submit.name = "submit";
        dom_input_submit.value = data.form.translation.submit;
        dom_div_submit.appendChild(dom_input_submit);
        this.dom_form_body.appendChild(dom_div_submit);
    }

    replace_script(i, elm) {
        var scripts = Array.from(elm.querySelectorAll("script"));

        if (i < scripts.length) {
            var oldScriptEl = scripts[i];

            const newScriptEl = document.createElement("script");

            var smartform = this;
            newScriptEl.addEventListener(
                "load",
                function () {
                    smartform.replace_script(i + 1, elm);
                },
                { once: true }
            );

            Array.from(oldScriptEl.attributes).forEach((attr) => {
                newScriptEl.setAttribute(attr.name, attr.value);
            });

            const scriptText = document.createTextNode(oldScriptEl.innerHTML);
            newScriptEl.appendChild(scriptText);

            oldScriptEl.parentNode.replaceChild(newScriptEl, oldScriptEl);
        }
    }

    createCaptcha(dom_div_captcha, captcha_config) {
        if (captcha_config["type"] == "RECAPTCHA") {
            dom_div_captcha.innerHTML =
                '<script type="text/javascript" src="https://www.google.com/recaptcha/api.js?render=' +
                captcha_config.public_key +
                '"></script> <input type="hidden" name="g-recaptcha-response" id="g-recaptcha-response-951" /> <script type="text/javascript"> function getReCaptcha() { grecaptcha.ready(function() { grecaptcha.execute("' +
                captcha_config.public_key +
                '").then(function(token) { document.getElementById("g-recaptcha-response-951").value = token; }); }); } getReCaptcha(); setInterval(function(){ getReCaptcha(); }, 150000); </script>';
        } else if (captcha_config["type"] == "FRIENDLYCAPTCHA") {
            dom_div_captcha.innerHTML =
                '<script src="/static/ext/friendly-challenge095/widget.module.min.js" type="module" async="async" defer="defer"></script> <script src="/static/ext/friendly-challenge095/widget.min.js" nomodule="nomodule" async="async" defer="defer"></script><div class="frc-captcha" data-sitekey="' +
                captcha_config.public_key +
                '" data-lang="' +
                captcha_config.language_code +
                '" data-puzzle-endpoint="' +
                captcha_config.endpoint +
                '"></div>';
        }
        this.replace_script(0, dom_div_captcha);
    }

    create_widgets(field) {
        switch (field.widget_id) {
            case 1:
                //Text Input
                field = new TextWidget(field, this.show_label_in);
                return field;
            case 2:
                //Dropdown
                field = new DropdownWidget(field, this.show_label_in);
                return field;
            case 3:
                //Hidden Input (cant take any values)
                return null;
            case 4:
                //Textarea
                field = new TextAreaWidget(field, this.show_label_in);
                return field;
            case 5:
                //Multiselect/Checkboxes
                field = new CheckboxesWidget(field, this.show_label_in);
                return field;
            case 6:
                //Date
                field = new DateWidget(field, this.show_label_in);
                return field;
            case 7:
                //Date Time
                field = new DateTimeWidget(field, this.show_label_in);
                return field;
            case 8:
                //Text Input (trimed)
                field = new TextTrimWidget(field, this.show_label_in);
                return field;
            case 9:
                //Radiobuttons
                field = new RadioButtonsWidget(field, this.show_label_in);
                return field;
            case 10:
                //ReadOnly
                field = new ReadOnlyWidget(field, this.show_label_in);
                return field;
            case 11:
                //Hidden Input (cant take any values)
                return null;
            case 12:
                //Hidden Input (cant take any values)
                return null;
            case 13:
                //Text Input (title case)
                field = new TextTitleCaseWidget(field, this.show_label_in);
                return field;
            case 14:
                //Password Input
                field = new PasswordWidget(field, this.show_label_in);
                return field;
            case 15:
                //Password Generator
                field = new PasswordGeneratorWidget(field, this.show_label_in);
                return field;
            case 16:
                //Date (Future)
                field = new DateFutureWidget(field, this.show_label_in);
                return field;
            case 17:
                //Date Time (Future)
                field = new DateTimeFutureWidget(field, this.show_label_in);
                return field;
            case 18:
                //Deprecated
                return null;
            case 19:
                //Hidden Input (cant take any values)
                return null;
            case 20:
                //Hidden Input (cant take any values)
                return null;
            case 21:
                //Checkbox
                field = new CheckboxWidget(field, this.show_label_in);
                return field;
            case 22:
                //Text Input (accepts empty input)
                field = new TextBlankWidget(field, this.show_label_in);
                return field;
            case 23:
                //Text Input (for single selection)
                field = new TextSingleSelectionWidget(field, this.show_label_in);
                return field;
            case 24:
                //Dropdown (with zero Option)
                field = new DropdownZeroOptionWidget(field, this.show_label_in);
                return field;
            case 25:
                //Radiobutton (with zero Option)
                field = new RadioButtonsZeroOptionWidget(field, this.show_label_in);
                return field;
            case 26:
                //Hidden Input (cant take any values)
                return null;
            case 27:
                //Text Input (lower case)
                field = new TextLowerCaseWidget(field, this.show_label_in);
                return field;
            case 28:
                //Text Input (upper case)
                field = new TextUpperCaseWidget(field, this.show_label_in);
                return field;
            case 29:
                //Date (Past)
                field = new DatePastWidget(field, this.show_label_in);
                return field;
            case 30:
                //Date Time (Past)
                field = new DateTimePastWidget(field, this.show_label_in);
                return field;
            case 31:
                //Textarea (accepts empty input)
                field = new TextAreaBlankWidget(field, this.show_label_in);
                return field;
            case 32:
                //Multiselect/Checkboxes (append only)
                field = new CheckboxesAppendWidget(field, this.show_label_in);
                return field;
            case 33:
                //Hidden Input (cant take any values)
                return null;
            case 37:
                //Date Time (with string to date)
                field = new DateTimeStringToTimeWidget(field, this.show_label_in);
                return field;
            case 38:
                //Date (with string to date)
                field = new DateStringToDateWidget(field, this.show_label_in);
                return field;
            case 41:
                //Checkbox (inverted)
                field = new CheckboxInvertedWidget(field, this.show_label_in);
                return field;
            case 44:
                //Text Input (filtered and 45 maximal length)
                field = new TextFilteredWidget(field, this.show_label_in);
                return field;
            case 45:
                //Text Input (filtered and 45 maximal length, accepts empty input)
                field = new TextFilteredBlankWidget(field, this.show_label_in);
                return field;
        }
    }
}
/*]]>*/
